<?php
/**
 *
 * @package    igumbi - online Bookingtool
 * @subpackage Modules
 * @license        GNU/GPL, see LICENSE.php
 * mod_igumbi is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */
class modIgumbiHelper
{
    /**
     * Retrieves the hello message
     *
     * @param array $params An object containing the module parameters
     * @access public
     */
    public static function getHello( $params )
    {
        //Obtain a database connection
        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
                    ->select($db->quoteName('hotel_id'))
                    ->from($db->quoteName('#__igumbi'))
                    ->where('id = 1');
        $db->setQuery($query);
        $result = $db->loadResult();
        return 'Hello, World,!'.$result;
    }
    public static function getAvForm( $params )
    {
        $txt = "<div id='avform'></div>";
        $txt = $txt."<hr id='avform_hr' style='margin:0;'/>";
        return $txt;
    }
    public static function getFreeRooms( $params )
    {
        return '<div id="free_rooms"></div>';
    }
    public static function getScript($params)
    {
        $hotel_id = $params->get('hotel_id');
        $lang     = $params->get('language');
        if ($params->get('wide') == 0) { $layout = "tall"; }
        if ($params->get('wide') == 1) { $layout = "wide"; }

        $responsive ="";
        if ($params->get('responsive') == 1) { $responsive = "&responsive=true"; }


        return '<script src="https://www.igumbi.net/seller/'.$hotel_id.'/'.$lang.'/start.js?layout='.$layout.$responsive.'&source=joomla"></script>';

    }
    public static function getLocalCSS($params)
    {
        return $params->get('custom_css');
    }
}

?>
